import { baseUrl } from '@/Http/helper'
import React from 'react'

const page = () => {
  return (
    <>
  <section className="page-title culture-bg">
    <div className="container-fluid">
      <div className="page-title-wrap">
        <div className="row align-items-center">
          <div className="col col-md-12 col-12">
            <div className="breadcumb-wrap">
              <h2 className="culture-heading">
                Empowering Growth, <br /> Delivering Success
              </h2>
              {/* <ol>
                          <li><a href="index.html"><i className="icon-36"></i> Home</a></li>
                          <li><a href="javascript:void(0);"><i className="icon-36"></i> Who We Are</a></li>
                          <li>About Us</li>
                      </ol> */}
            </div>
          </div>
          {/* <div className="col col-lg-6">
                  <div className="breadcumb-img">
                      <img src={`${baseUrl}front/assets/images/page-title_img_01.jpg`} alt="">
                  </div>
              </div> */}
        </div>
      </div>
    </div>
  </section>
  <section className="culture-sec">
    <div className="container">
      <div className="row justify-content-center">
        <div className="culture-top-content">
          <h2 className="bighd text-center">Our Culture at Sellora</h2>
          <p className="culture-para">
            At Sellora, we believe that culture is the backbone of our success.
            Our core values of innovation, collaboration, integrity, and
            customer-centricity are not just principles we talk about—they are
            woven into everything we do.
          </p>
        </div>
      </div>
      <div className="row">
        <div
          className="col-lg-6 col-md-6 order-lg-2 order-md-2 wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="about-us-img culture-img">
            <img
              src={`${baseUrl}front/assets/images/Career-img/career-img-05.jpg`}
              alt="career image"
            />
          </div>
        </div>
        <div
          className="col-lg-6 col-md-6 order-lg-1 order-md-1  wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="career-contents career-content2">
            <h4 className="bighd-subtitle">Innovation at the Core</h4>
            <p>
              We thrive on innovation. The dynamic world of e-commerce is
              ever-changing, and we are committed to staying ahead of the curve.
              At Sellora, we encourage our teams to think creatively, challenge
              conventional approaches, and pursue new ideas. Our goal is to
              continuously innovate, ensuring that we offer cuttingedge
              solutions to meet the evolving needs of our customers. Whether
              it’s improving user experience, optimizing product listings, or
              streamlining fulfillment services, we are driven by a relentless
              pursuit of progress.
            </p>
          </div>
          {/* <p>When an unknown printer took a galley of type and scrambled it to make a type specimen book.Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p> */}
        </div>
      </div>
      <div className="row mt-5 about-row">
        <div
          className="col-lg-6 col-md-6 order-lg-1 order-md-1 wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="about-us-img culture-img">
            <img
              src={`${baseUrl}front/assets/images/Career-img/career-img-06.jpg`}
              alt="career image"
            />
          </div>
        </div>
        <div
          className="col-lg-6 col-md-6 order-lg-2 order-md-2  wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="career-contents career-content2">
            <h4 className="bighd-subtitle">A Collaborative Environment</h4>
            <p>
              We understand that collaboration is key to achieving great things.
              Our teams work cross-functionally, combining diverse skills and
              perspectives to tackle challenges and create impactful solutions.
              We nurture an environment where every team member, regardless of
              their role or background, feels empowered to contribute ideas. We
              believe that the best results come from bringing together creative
              minds, fostering open communication, and building trust within our
              teams. At Sellora, success is a shared achievement.
            </p>
          </div>
          {/* <p>When an unknown printer took a galley of type and scrambled it to make a type specimen book.Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p> */}
        </div>
      </div>
      <div className="row mt-5 about-row">
        <div
          className="col-lg-6 col-md-6 order-lg-2 order-md-2 wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="about-us-img culture-img">
            <img
              src={`${baseUrl}front/assets/images/Career-img/career-img-07.jpg`}
              alt="career image"
            />
          </div>
        </div>
        <div
          className="col-lg-6 col-md-6 order-lg-1 order-md-1  wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="career-contents career-content2">
            <h4 className="bighd-subtitle">Integrity and Trust</h4>
            <p>
              At the heart of our culture is integrity. We are committed to
              ethical practices in all our dealings, whether with customers,
              partners, or employees. Trust is the foundation of every
              successful relationship, and we take pride in maintaining
              transparency and honesty in everything we do. Our teams uphold
              these values in both internal collaboration and external
              engagements, ensuring that our commitment to doing what’s right is
              reflected in our everyday actions.
            </p>
          </div>
          {/* <p>When an unknown printer took a galley of type and scrambled it to make a type specimen book.Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p> */}
        </div>
      </div>
      <div className="row mt-5 about-row">
        <div
          className="col-lg-6 col-md-6 order-lg-1 order-md-1 wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="about-us-img culture-img">
            <img
              src={`${baseUrl}front/assets/images/Career-img/career-img-08.jpg`}
              alt="career image"
            />
          </div>
        </div>
        <div
          className="col-lg-6 col-md-6 order-lg-2 order-md-2  wow fadeInUp"
          data-wow-delay="0s"
        >
          <div className="career-contents career-content2">
            <h4 className="bighd-subtitle">Customer-Centric Approach </h4>
            <p>
              Our customers are the driving force behind our innovation and our
              success. We place their needs at the forefront of every decision,
              from the services we offer to the products we deliver. Sellora’s
              customer-first mindset means we’re constantly seeking to enhance
              user experience, whether it’s through personalized support,
              seamless navigation, or timely fulfillment. We actively listen to
              customer feedback and strive to exceed expectations, delivering
              solutions that simplify their journey and create long-lasting
              relationships.
            </p>
          </div>
          {/* <p>When an unknown printer took a galley of type and scrambled it to make a type specimen book.Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p> */}
        </div>
      </div>
    </div>
  </section>
  <section className="careersection2 culture-sec2">
    <div className="container">
      {/* <h4 className="bighd text-center">Why Join Sellora?</h4> */}
      <div className="row justify-content-center">
        <div className="col-md-6 col-lg-4 col-sm-6">
          <div className="ethoscont culture-ethoscont">
            {/* <img src={`${baseUrl}front/assets/images/Career-img/career-icon-01.jpg`} alt=""> */}
            <h3 className="">Continuous Learning and Growth</h3>
            <p className="">We prioritize knowledge and self-improvement.</p>
            <p>Opportunities for learning through training and mentorship</p>
            <p>Empower employees to thrive in their careers.</p>
          </div>
        </div>
        <div className="col-md-6 col-lg-4 col-sm-6">
          <div className="ethoscont culture-ethoscont">
            {/* <img src={`${baseUrl}front/assets/images/Career-img/career-icon-02.jpg`} alt=""> */}
            <h3 className="">Work-Life Balance</h3>
            <p className="">
              A balanced life leads to happier, more productive teams.
            </p>
            <p>Flexible work arrangements and wellness initiatives.</p>
            <p>We support both personal and professional well-being.</p>
          </div>
        </div>
        <div className="col-md-6 col-lg-4 col-sm-6">
          <div className="ethoscont culture-ethoscont">
            {/* <img src={`${baseUrl}front/assets/images/Career-img/career-icon-03.jpg`} alt=""> */}
            <h3 className="">Community and Social Responsibility</h3>
            <p className="">
              We actively promote sustainability and social responsibility.
            </p>
            <p>
              Support local communities and engage in meaningful initiatives.
            </p>
            <p>Believe in making a positive impact beyond business.</p>
          </div>
        </div>
      </div>
    </div>
  </section>
</>

  )
}

export default page