

"use client";
import { Geist, Geist_Mono } from "next/font/google";
// import "./globals.css";
import Header from "./(front)/frontComponents/Header";
import Footer from "./(front)/frontComponents/Footer";
import { useEffect, useLayoutEffect, useState  } from "react";
import Script from "next/script";
import { usePathname } from "next/navigation";
import dynamic from "next/dynamic";
import BackToTop from "./(front)/frontComponents/BackToTop";
import { AppProvider } from "./contaxtData/contextData";
import { CartProvider } from "./contaxtData/cartContaxt";
import { baseUrl } from "@/Http/helper";
import { sellerUrl } from "@/Http/urlHelper";
import { CategoryProvider } from "./contaxtData/CategoryProvider";


const jQuery = dynamic(() => import('jquery'), { ssr: false });

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

// export const metadata = {
//   title: "Create Next App",
//   description: "Generated by create next app",
// };

export default function RootLayout({ children }) {

 
  const pathname = usePathname();
  if(pathname.startsWith('/sellor') || pathname.startsWith('/sellor-dashboard')){
    window.location.href=sellerUrl
}

  const isCustomLayout  = pathname.startsWith('/sellor') || pathname.startsWith('/sellor-dashboard') || pathname.startsWith('/consumer') || pathname.startsWith('/admin') || pathname.startsWith('/api');

  useEffect(() => {
    // jQuery will be available after it's loaded on the client-side
    if (typeof window !== 'undefined') {
      // Ensure jQuery is accessible globally
      window.jQuery = jQuery;
      window.$ = jQuery;
    }
  }, []);

 
  useEffect(()=>{
  
    $('.logoLoader').css('display', 'none')
  },[pathname])

  if (isCustomLayout) {
    return (
      <AppProvider> 
         <>{children}</> 
         </AppProvider>
      ); // Return just the children for custom layout
  }


  

  return (
    <html lang="en"> 
      <head>
      <meta charSet="UTF-8" />
      <meta name="description" content="" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <meta name="keywords" content="" />
      <title>Sellora</title>
      <link rel="shortcut icon" href="/front/favicon.ico" type="image/x-icon" />
    
      <link rel="stylesheet preload" href="/front/assets/css/plugins.css" as="style" />
      <link rel="stylesheet preload" href="/front/assets/css/style.css" as="style" />
      </head>
      <body className="index-five">
      
        
        <CartProvider >
          <CategoryProvider>
        {/* <Header />
        {children}
        <Footer/> */}

        {!isCustomLayout && <Header />}
        <div className="logoLoader">
          <div className="innerloader">
            <img src={`${baseUrl}front/assets/images/logo-01.png`} />
          </div>
        </div>
        {children}
        {!isCustomLayout && <Footer />}
        <BackToTop/>
        


    <Script defer src="/front/assets/js/plugins.js"></Script>
    <Script defer src="/front/assets/js/main.js"></Script>
    </CategoryProvider>
    </CartProvider>
      </body>
    </html>
  );
}
